/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.git.core.GitProjectRefresher;
import com.aptana.git.core.GitResourceListener;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepositoryManager;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.internal.core.github.GithubManager;
import com.aptana.git.internal.core.storage.CommitFileRevision;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.history.IFileRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GitPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.git.core";
    private static GitPlugin plugin;
    private GitProjectRefresher fRepoListener;
    private IResourceChangeListener fGitResourceListener;
    private GitRepositoryManager fGitRepoManager;
    private GithubManager fGithubManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job("Add Git Index Resource listener"){

            protected IStatus run(IProgressMonitor monitor) {
                GitPlugin.this.fGitResourceListener = new GitResourceListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener(GitPlugin.this.fGitResourceListener, 1);
                GitPlugin.this.fRepoListener = new GitProjectRefresher();
                GitPlugin.this.getGitRepositoryManager().addListener(GitPlugin.this.fRepoListener);
                GitPlugin.this.getGitRepositoryManager().addListenerToEachRepository(GitPlugin.this.fRepoListener);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fGitResourceListener);
            this.getGitRepositoryManager().removeListener(this.fRepoListener);
            this.getGitRepositoryManager().removeListenerFromEachRepository(this.fRepoListener);
            if (this.fGitRepoManager != null) {
                this.fGitRepoManager.cleanup();
            }
        }
        finally {
            this.fGitRepoManager = null;
            this.fGithubManager = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static GitPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static IFileRevision revisionForCommit(GitCommit commit, IPath repoRelativePath) {
        return new CommitFileRevision(commit, repoRelativePath);
    }

    public IPath getGIT_SSH() {
        File sshwFile;
        if ("win32".equals(Platform.getOS()) && (sshwFile = ResourceUtil.resourcePathToFile((URL)FileLocator.find((Bundle)this.getBundle(), (IPath)Path.fromPortableString((String)"$os$/sshw.exe"), null))).isFile()) {
            return Path.fromOSString((String)sshwFile.getAbsolutePath());
        }
        return null;
    }

    public IPath getSSH_ASKPASS() {
        File askpassFile;
        if ("win32".equals(Platform.getOS())) {
            return null;
        }
        if (("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) && (askpassFile = ResourceUtil.resourcePathToFile((URL)FileLocator.find((Bundle)this.getBundle(), (IPath)Path.fromPortableString((String)"$os$/ssh-askpass.tcl"), null))).isFile()) {
            return Path.fromOSString((String)askpassFile.getAbsolutePath());
        }
        return null;
    }

    public IPath getGIT_ASKPASS() {
        File askpassFile;
        if ("win32".equals(Platform.getOS())) {
            return this.getGIT_SSH();
        }
        if (("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) && (askpassFile = ResourceUtil.resourcePathToFile((URL)FileLocator.find((Bundle)this.getBundle(), (IPath)Path.fromPortableString((String)"$os$/askpass.tcl"), null))).isFile()) {
            return Path.fromOSString((String)askpassFile.getAbsolutePath());
        }
        return null;
    }

    public synchronized IGitRepositoryManager getGitRepositoryManager() {
        if (this.fGitRepoManager == null) {
            this.fGitRepoManager = new GitRepositoryManager();
        }
        return this.fGitRepoManager;
    }

    public synchronized IGithubManager getGithubManager() {
        if (this.fGithubManager == null) {
            this.fGithubManager = new GithubManager();
        }
        return this.fGithubManager;
    }
}

